version 17.0

set more off

*   ***************************************************************** *;
*   ***************************************************************** *;
*   File-Name:   regionalineq.do           	                          *;
*   Date:        Oct 4, 2023	   		                              *;
*   Authors:     Lisa Dellmuth					                      *;
*   Input File:  evswvs_recoded.dta                                   *; 
*   ****************************************************************  *;
*   ****************************************************************  *;

*   ****************************************************************  *;
*   This file replicates the empirical information in the paper       *;
*	Regional inequalities and political trust in a global context".   *;
*	See separate Python script for replication of Figures 1 and 2.    *;
*   ****************************************************************  *;


use evswvs_recoded.dta, clear

/*
Recoded variables:

*recode EVS/WVS data

recode E069_18A 2=1 3=0 4=0, gen(confdum_ro)
recode E069_11 2=1 3=0 4=0, gen(confdum_gov)

label define confidence 0 "None or not very much" 1 "Quite a lot or a great deal"
label values confdum_ro confidence
label values confdum_gov confidence

recode E069_18A 1=3 3=1 4=0, gen(conf_ro)
recode E069_11 1=3 3=1 4=0, gen(conf_gov)

label define confidence_c 0 "None" 1 "Not very much" 2 "Quite a lot" 3 "A great deal"
label values confgov confidence_c
label values conf_ro confidence_c

rename E111_01 polsatisfaction
recode polsatisfaction 1=0 2=1 3=2 4=3 5=4 6=5 7=6 8=7 9=8 10=9
label drop E111_01

rename A173 control
recode control 1=0 2=1 3=2 4=3 5=4 6=5 7=6 8=7 9=8 10=9
label drop A173
tab control

gen age = X003
sum age 

rename A165 gentrust 
recode gentrust 2=0 
tab gentrust

gen male = X001 
recode male 2=0  // 1= male; 0= female
tab male
label drop X001

*recode contextual information

gen lgdp_capita=ln(gdp_capita)
gen gnic_5yr_avg=exp(lgnic_5yr_avg)
gen gnic_1yr=exp(lgnic_1yr)

gen city=.
replace city=0 if size_5c==1|size_5c==2
replace city=1 if size_5c==3|size_5c==4|size_5c==5
tab city

preserve
collapse (mean) gnic_1yr, by(su country)
drop if gnic_1yr==.
ed
by country, sort: gen rid = _n
sum rid
egen min = min(gnic_1yr), by(country)
egen max = max(gnic_1yr), by(country)
egen p90 = pctile(gnic_1yr), p(90) by(country)
egen p10 = pctile(gnic_1yr), p(10) by(country)
gen regineq_maxmin=max-min // range of GDP in mio USD
gen regineq_maxregional=max-gnic_1yr // differences between the GDP  of a region and the richest region's GDP  of the same country
replace regineq_maxregional=0 if regineq_maxregional<0
sort regineq_maxregional
replace regineq_maxregional=0 in 1/55

egen max = max(gnic_1yr), by(country)
by country, sort: gen regineq_maxperc=gnic_1yr/max
label var regineq_maxperc "Regional income as a % of the income of the richest region in the country"

egen mean = mean(gnic_1yr), by(country)
by country, sort: gen regineq_meanperc=gnic_1yr/mean
label var regineq_meanperc "Regional income as a % of the income of the average region in the country"

save gdp.dta, replace


* Merge to survey dataset 

restore

merge m:m su using gdp.dta

drop resid_confgovNEW
reg confgov lgnic_1yr regineq_meanperc i.X025R age male control city memberdum hhinc
predict double resid_confgovNEW, residuals

gen weight=gwght*wght_eq1000

gen eums=0
replace eums=1 if cntry_AN =="AT"
replace eums=1 if cntry_AN =="BG"
replace eums=1 if cntry_AN =="CY"
replace eums=1 if cntry_AN =="CZ"
replace eums=1 if cntry_AN =="DE"
replace eums=1 if cntry_AN =="DK"
replace eums=1 if cntry_AN =="EE"
replace eums=1 if cntry_AN =="NL"
replace eums=1 if cntry_AN =="PL"
replace eums=1 if cntry_AN =="RO"
replace eums=1 if cntry_AN =="ES"
replace eums=1 if cntry_AN =="FI"
replace eums=1 if cntry_AN =="FR"
replace eums=1 if cntry_AN =="HR"
replace eums=1 if cntry_AN =="HU"
replace eums=1 if cntry_AN =="IT"
replace eums=1 if cntry_AN =="LT"
replace eums=1 if cntry_AN =="LV"
replace eums=1 if cntry_AN =="PT"
replace eums=1 if cntry_AN =="SE"
replace eums=1 if cntry_AN =="SI" 
replace eums=1 if cntry_AN =="GR" 
tab eums
tab cntry if eums==1
tab cntry if eums==0


* Country and organization list

The Asia-Pacific Economic Cooperation (APEC): in Japan, Malaysia, South Korea
The Arab League: in Iraq, Jordan, Lebanon, Tunisia
The Association of South East Asian Nations (ASEAN): in Indonesia, Myanmar, Philippines, Thailand, Vietnam
The African Union (AU): in Ethiopia, Nigeria, Zimbabwe
The Mercosur: in Argentina, Bolivia, Brasil, Colombia, Ecuador
The European Union (EU): in Austria, Bulgaria, Croatia, Cyprus, Czech Republic, Denmark, Estonia, Finland, France, Germany, Greece, Hungary, Italy, Latvia, Lithuania, Netherlands, Poland, Portugal, Romania, Slovenia, Spain and Sweden.

gen ro=.
replace ro = 1 if cntry_AN=="ET"|cntry_AN=="NI"|cntry_AN=="ZW"
replace ro = 2 if  cntry_AN=="IQ"|cntry_AN=="JO"|cntry_AN=="LB"|cntry_AN=="TN"
replace ro = 3 if cntry_AN=="JP"|cntry_AN=="MY"|cntry_AN=="KR"
replace ro = 4 if cntry_AN=="ID"|cntry_AN=="MM"|cntry_AN=="VN"|cntry_AN=="PH"|cntry_AN=="TH"
replace ro = 5 if eums==1
replace ro = 6 if cntry_AN=="BR"|cntry_AN=="AR"|cntry_AN=="BO"|cntry_AN=="CO"|cntry_AN=="EC"
label define ro 1 "AU" 2 "Arab League" 3 "APEC" 4 "ASEAN" 5 "EU" 6 "Mercosur" 
label values ro ro
tab ro

gen gnic_1yrmln=gnic_1yr/1000

gen lgnic_1yrmln=ln(gnic_1yrmln)

compress

save evswvs_recoded.dta, replace

*/


*use margins to save Average Marginal Effects (AME) as presented in the paper 

*Table 2 in main paper

*EU sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
margins, at(regineq_meanperc=(.4(.1)4.1)) atmeans vsquish post // include the post option so that we can easily get estimates and their standard errors. vsquish produces a more compact output.
margins, at(lgnic_1yr=(7.4(.1)11.4)) atmeans vsquish post  
eststo m1eu:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu:margins, dydx(*) post
margins, at(lgnic_1yr=(0(1)5)) atmeans vsquish post //  include the post option so that we can easily get the estimates and their standard errors.  vsquish option to produce a more compact output.

*global sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m5all:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m6all:margins, dydx(*) post

esttab m1eu m2eu m3gl m4gl m5all m6all using table3.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 



*Robustness checks (Appendix C)


*Table C1 = Table 2 with interaction terms

*gen lgnic_1yrxedu2=lgnic_1yr*edu2
*gen lgnic_1yrxedu3=lgnic_1yr*edu3
*tab X025R, gen(edu)

*EU sample
melogit confdum_gov lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m1eu:margins, dydx(*) post
 

melogit confdum_ro lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu:margins, dydx(*) post

*global sample
melogit confdum_gov lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl:margins, dydx(*) post
 
melogit confdum_ro lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m5all:margins, dydx(*) post

melogit confdum_ro lgnic_1yr edu2 edu3 lgnic_1yrxedu2 lgnic_1yrxedu3  regineq_meanperc memberdum unemployed hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
eststo m6all:margins, dydx(*) post

esttab  m1eu m2eu m3gl m4gl m5all m6all using c1.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 

 
*Table C2 = Table 2 with interaction terms

*gen regineq_meanpercxedu2=regineq_meanperc*edu2
*gen regineq_meanpercxedu3=regineq_meanperc*edu3


*EU sample
melogit confdum_gov lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m1eu:margins, dydx(*) post
 
melogit confdum_ro lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu:margins, dydx(*) post

*global sample
melogit confdum_gov lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl:margins, dydx(*) post
 

melogit confdum_ro lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m5all:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_meanperc edu2 edu3 regineq_meanpercxedu2 regineq_meanpercxedu3 memberdum unemployed hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m6all:margins, dydx(*) post

esttab  m1eu m2eu m3gl m4gl m5all m6all using C2_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 




*Table C3 = Table 2 excluding closed autocracies

preserve
drop if country=="Jordan"|country=="Myanmar"|country=="Thailand"|country=="Vietnam"

*EU sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m1eu2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu2:margins, dydx(*) post 

*global sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl2:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m5all2:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
eststo m6all2:margins, dydx(*) post

esttab  m1eu2 m2eu2 m3gl2 m4gl2 m5all2 m6all2 using C3_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 

 


*Table C4 = Table 2 excluding all autocracies

preserve
drop if country=="Jordan"|country=="Myanmar"|country=="Thailand"|country=="Vietnam" // closed autocracies
drop if country=="Nigeria"|country=="Philippines"|country=="Malaysia"|country=="Lebanon"|country=="Jordan"|country=="Iraq"|country=="Hungary"|country=="Ethiopia"|country=="Egypt" // electoral autocracies


*EU sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m1eu2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu2:margins, dydx(*) post 

*global sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl2:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m5all2:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
eststo m6all2:margins, dydx(*) post

esttab  m1eu2 m2eu2 m3gl2 m4gl2 m5all2 m6all2 using C4_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 





*Table C5 = Table 2 without regineq_meanperc

*EU sample
melogit confdum_gov lgnic_1yr memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
estat ic // to get aic and bic
eststo m1eu:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
estat ic // to get aic and bic
eststo m2eu:margins, dydx(*) post 

*global sample
melogit confdum_gov lgnic_1yr memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
estat ic 
eststo m3gl:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
estat ic
eststo m4gl:margins, dydx(*) post 

*pooled sample
melogit confdum_gov lgnic_1yr memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
estat ic
eststo m5all:margins, dydx(*) post
 
melogit confdum_ro lgnic_1yr memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
estat ic
eststo m6all:margins, dydx(*) post
 
esttab  m1eu m2eu m3gl m4gl m5all m6all using C5_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 




*Table C6 = Table 2 without lgnic

*EU sample
melogit confdum_gov regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
estat ic // to get aic and bic
eststo m1eu:margins, dydx(*) post 

melogit confdum_ro regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
estat ic // to get aic and bic
eststo m2eu:margins, dydx(*) post 

*global sample
melogit confdum_gov regineq_meanperc memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
estat ic 
eststo m3gl:margins, dydx(*) post 

melogit confdum_ro regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
estat ic
eststo m4gl:margins, dydx(*) post 

*pooled sample
melogit confdum_gov regineq_meanperc memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
estat ic
eststo m5all:margins, dydx(*) post 

melogit confdum_ro regineq_meanperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
estat ic
eststo m6all:margins, dydx(*) post 

esttab  m1eu m2eu m3gl m4gl m5all m6all using C6_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 




*Table C7 = Table 2 using alternative variable for regional disadvantage


*EU sample
melogit confdum_gov lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male if eums==1 [pweight=weight] || su: || cntry:,intmethod(pcaghermite)
eststo m1eu2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW if eums==1 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m2eu2:margins, dydx(*) post 

*global sample
melogit confdum_gov lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male if eums==0 [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m3gl2:margins, dydx(*) post 

melogit confdum_ro lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro if eums==0 [pweight=weight] || su:  || cntry: ,intmethod(pcaghermite)
eststo m4gl2:margins, dydx(*) post

*pooled sample
melogit confdum_gov lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male [pweight=weight] || su:  || cntry:,intmethod(pcaghermite)
eststo m5all2:margins, dydx(*) post

melogit confdum_ro lgnic_1yr regineq_maxperc memberdum unemployed i.X025R hhinc control city age male resid_confgovNEW i.ro [pweight=weight] || su:   || cntry:,intmethod(pcaghermite)
eststo m6all2:margins, dydx(*) post

esttab  m1eu2 m2eu2 m3gl2 m4gl2 m5all2 m6all2 using C7_AME.rtf, starlevels(* .05 ** .01 *** .001) b(%9.3f) aic bic scalars(ll) nodepvars not se(%9.3f) replace 

